



/******************************************************************************************
 *                                                                                        *
 *  Ex1.     :  Read BCD ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                    *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU        : ATMEGA168(ET-BASE AVR EASY MEGA168)                                *
 *                   : X-TAL : 16 MHz                                                     *
 *                                                                                        *
 * Compiler Editor   : Arduino 1.0.4                                                      *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 14/April/2015                                                      *
 *                                                                                        *
 * Port Interface    :  -- MCU-AT MEGA168--               --ET-Matrix Key Decoder--       *  
 *                                                                                        *   
 *   I/P BCD Port    :   D8(Input)          Connect                 BCD 1                 * 
 *                       D9(Input)          Connect                 BCD 2                 *
 *                       D10(Input)         Connect                 BCD 4                 *
 *                       D11(Input)         Connect                 BCD 8                 *
 *                       D12(Input)         Connect                 P#/R Ststus Key       *
 *                                                                                        *
 *  O/P Display Port :                                                                    *
 *                                                                                        *
 *               LED :   Connect Common Anode(LED Active Low)                             *
 *                       A0(D14)           Connect                 LED0  (BCD1)           *
 *                       A1(D15)           Connect                 LED1  (BCD2)           *
 *                       A2(D16)           Connect                 LED2  (BCD4)           *
 *                       A3(D17)           Connect                 LED3  (BCD8)           *
 *                                                                                        *
 *                                                                                        *
 *             Uart0 :   D0 = TXDO          Connect                Rx PC                  *  
 *                       D1 = RXD0          Connect                Tx PC                  *
 *                       Baud Rate = 9600  at Clock 16 MHz                                *
 *                                                                                        *
 *                                                                                        *
 *   Operation  : When Touch Key will                                                     *
 *                                    -Show BCD Key Code To LED                           *  
 *                                    -Show BCD Key Code to RS232(Hyperterminal)          *
 *                                                                                        *
 ******************************************************************************************/

//----------- Defind BCD I/P Port D8..D12 ---------------- 

#define BCD1           8      //D8
#define BCD2           9      //D9
#define BCD4          10      //D10   
#define BCD8          11      //D11
#define PR            12      //D12


//------------Define O/P Port LED Display BCD Code ------------

#define LED0          14     //A0   
#define LED1          15     //A1  
#define LED2          16     //A2  
#define LED3          17     //A3  

//--------- Golbal Variable -----------

 unsigned char kc8,kc4,kc2,kc1                 ;
 char key_code ;

//****************************** Sub Program ******************************

//---------------------- Check Press/Release Key -------------------

char Check_PR(void)    
 {
   char p_r   ;
        
     p_r = digitalRead(PR)         ;    //Read Status Key
   
     if(p_r != 1)                       //Check Statue Key
       return (0)                  ;    //Press Key Return 0 (D12=0)
     else
       return (1)                  ;    //Release Key Return 1   (D12=1)
 }


//---------- Read BCD Key Code -----------------

 void RD_KeyCode(void) 
  {
    //------- Read BCD bit-------
     kc8 = digitalRead(BCD8)           ;   //Read BCD(8) Code bit D11    (Use for LED)
     kc4 = digitalRead(BCD4)           ;   //Read BCD(4) Code bit D10 
     kc2 = digitalRead(BCD2)           ;   //Read BCD(2) Code bit D9   
     kc1 = digitalRead(BCD1)           ;   //Read BCD(1) Code bit D8   
     
     //----- Bit to byte for RS232 -----
     key_code = kc8                    ;   //Total Key code 4 bit to byte (Use for RS232)
     key_code = (key_code <<1)| kc4    ;
     key_code = (key_code <<1)| kc2    ;
     key_code = (key_code <<1)| kc1    ;
     key_code = key_code & 0x0F        ;
    
  }



/*##########################################################################
  ##                                                                      ##
  ##                               SETUP                                  ##
  ##                                                                      ##
  ##########################################################################*/

void setup() 
{ 
 //------------Initial Port D8..D12 =Input for Read Key Code --------------- 
  
    pinMode(BCD1,INPUT_PULLUP)           ; //Set Status pin D8  = Input Pull-Up 
    pinMode(BCD2,INPUT_PULLUP)           ; //Set Status pin D9  = Input Pull-Up  
    pinMode(BCD4,INPUT_PULLUP)           ; //Set Status pin D10 = Input Pull-Up  
    pinMode(BCD8,INPUT_PULLUP)           ; //Set Status pin D11 = Input Pull-Up  
    pinMode(PR,INPUT_PULLUP)             ; //Set Status pin D12 = Input Pull-Up  
 
  //----------- Initial Port A0..A3 = Output LED for Display BCD Key Code
  
    pinMode(LED0,OUTPUT)                 ; //Set Status pin A0 = Output   
    pinMode(LED1,OUTPUT)                 ; //Set Status pin A1 = Output   
    pinMode(LED2,OUTPUT)                 ; //Set Status pin A2 = Output   
    pinMode(LED3,OUTPUT)                 ; //Set Status pin A3 = Output   
    
    
    digitalWrite(LED0,HIGH)              ; // Default set Output Port OFF LED 
    digitalWrite(LED1,HIGH)              ;
    digitalWrite(LED2,HIGH)              ;
    digitalWrite(LED3,HIGH)              ;
    

  //--------------------- Initial UART0 (D0=Tx ,D1=Rx)----------------------
 
    Serial.begin(9600)                   ; //Set Board Rate Uart0 =9600
  
}


/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 #######################################################################*/
 

void loop() 
{  
   Serial.print("*************************************************************************\r\n");    
   Serial.print("**          Ex1.TEST READ BCD KEY CODE ET-Matrix Key Decoder           **\r\n");        
   Serial.print("*************************************************************************\r\n"); 
  
   while(1)
   {
      if(!Check_PR())                             //Step1: Check  pressed key (Check_PR()=0:Press,1:Release) 
        {
           RD_KeyCode()                        ;  //Step2: Read Key Code
         
        //---------- Step3:Program Respond press key for user ------------
       
           //--- Display BCD Key Code to LED Common Anode ---//
            digitalWrite(LED3,(~kc8)&0x01);   // sets the LED3 
            digitalWrite(LED2,(~kc4)&0x01);   // sets the LED2 
            digitalWrite(LED1,(~kc2)&0x01);   // sets the LED1 
            digitalWrite(LED0,(~kc1)&0x01);   // sets the LED0
         
         
          //--- Display BCD Key Code to RS232 PC(BR=9600) ---//
           
           Serial.print("BCD Key_Code  = 0x0")    ;   //Print Key Code Out RS232
           Serial.print(key_code,HEX)             ;
           Serial.print("\n\r")                   ;
           
         
          while(!Check_PR()){;}                   ; //Wait Release Key (=1 exit loop)
       }          
   }  
}








